// options.js
document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('optionsForm');
    const downloadPathInput = document.getElementById('downloadPath');
    const descriptionInput = document.getElementById('description');
    const askLocationCheckbox = document.getElementById('askLocation');
    const statusDiv = document.getElementById('status');

    // โหลดค่าที่บันทึกไว้
    loadSavedOptions();

    // บันทึกการตั้งค่าเมื่อส่งฟอร์ม
    form.addEventListener('submit', function (e) {
        e.preventDefault();
        saveOptions();
    });

    function loadSavedOptions() {
        chrome.storage.sync.get(['downloadPath', 'description', 'askLocation'], function (result) {
            console.log('โหลดการตั้งค่า:', result);

            if (result.downloadPath) {
                downloadPathInput.value = result.downloadPath;
            }
            if (result.description) {
                descriptionInput.value = result.description;
            }
            if (result.askLocation !== undefined) {
                askLocationCheckbox.checked = result.askLocation;
            }
        });
    }

    function saveOptions() {
        const downloadPath = downloadPathInput.value.trim();
        const description = descriptionInput.value.trim();
        const askLocation = askLocationCheckbox.checked;

        console.log('กำลังบันทึกการตั้งค่า:', { downloadPath, description, askLocation });

        chrome.storage.sync.set({
            downloadPath: downloadPath,
            description: description,
            askLocation: askLocation
        }, function () {
            if (chrome.runtime.lastError) {
                console.error('ข้อผิดพลาดในการบันทึก:', chrome.runtime.lastError);
                showStatus('❌ เกิดข้อผิดพลาดในการบันทึก: ' + chrome.runtime.lastError.message, 'error');
            } else {
                console.log('บันทึกการตั้งค่าเรียบร้อยแล้ว');

                // ตรวจสอบว่าบันทึกจริงหรือไม่
                chrome.storage.sync.get(['downloadPath', 'description', 'askLocation'], function (result) {
                    console.log('ตรวจสอบการบันทึก:', result);

                    if (result.downloadPath === downloadPath &&
                        result.description === description &&
                        result.askLocation === askLocation) {
                        showStatus('✅ บันทึกการตั้งค่าเรียบร้อยแล้ว!', 'success');
                    } else {
                        showStatus('⚠️ การบันทึกอาจไม่สมบูรณ์', 'error');
                    }
                });
            }

            // ซ่อนข้อความหลัง 3 วินาที
            setTimeout(() => {
                hideStatus();
            }, 3000);
        });
    }

    function showStatus(message, type) {
        statusDiv.textContent = message;
        statusDiv.className = `status ${type}`;
        statusDiv.style.display = 'block';
    }

    function hideStatus() {
        statusDiv.style.display = 'none';
    }
});